<?php
// index_has_process.php
// Backend para procesar formularios de Hotel Atacama Suites - TRANSBANK INTEGRATION

// Carga de dependencias solicitadas (si tienes composer, asegúrate de que HTTP_Request2 esté instalado)
// Si no tienes composer, puedes usar cURL nativo como se muestra abajo para mayor portabilidad.
require_once 'vendor/pear/http_request2/HTTP/Request2.php';
require_once 'vendor/autoload.php';

header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");

// --- CREDENCIALES TRANSBANK (INTEGRACIÓN / TEST) ---
define('TBK_API_KEY_ID', '597055555532');
define('TBK_API_KEY_SECRET', '579B532A7440BB0C9079DED94D31EA1615BACEB56610332264630D42D0A36B1C');
define('TBK_URL', 'https://webpay3gint.transbank.cl/rswebpaytransaction/api/webpay/v1.0/transactions');

function jsonResponse($status, $title, $message, $data = null) {
    echo json_encode(['status' => $status, 'title' => $title, 'message' => $message, 'data' => $data]);
    exit;
}

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    jsonResponse('error', 'Error', 'Solo POST permitido.');
}

$action = $_POST['action'] ?? '';

try {
    switch ($action) {
        // ... (otros casos como check_availability, reserve_suite se mantienen igual) ...

        case 'initiate_transbank_payment':
            $amount = intval($_POST['amount'] ?? 0);
            $buyOrder = 'order_' . uniqid(); // Orden única
            $sessionId = 'sess_' . uniqid();
            
            // URL de retorno a la que Transbank redirigirá después del pago (debe ser una URL válida de tu sitio)
            // Para pruebas locales, esto podría fallar si Transbank no puede ver tu localhost, pero en integración
            // el flujo del navegador sí funciona.
            $returnUrl = 'http://localhost/tu_proyecto/confirmacion_transbank.php'; 

            if ($amount <= 0) jsonResponse('error', 'Error', 'Monto inválido.');

            $payload = [
                "buy_order" => $buyOrder,
                "session_id" => $sessionId,
                "amount" => $amount,
                "return_url" => $returnUrl
            ];

            // Opción A: Usando HTTP_Request2 como solicitaste
            /*
            $request = new HTTP_Request2();
            $request->setUrl(TBK_URL);
            $request->setMethod(HTTP_Request2::METHOD_POST);
            $request->setConfig(['follow_redirects' => TRUE]);
            $request->setHeader([
                'Tbk-Api-Key-Id' => TBK_API_KEY_ID,
                'Tbk-Api-Key-Secret' => TBK_API_KEY_SECRET,
                'Content-Type' => 'application/json'
            ]);
            $request->setBody(json_encode($payload));
            $response = $request->send();
            $responseBody = $response->getBody();
            $httpCode = $response->getStatus();
            */

            // Opción B: Usando cURL nativo (Más común y portable si no tienes PEAR instalado)
            $ch = curl_init(TBK_URL);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Tbk-Api-Key-Id: ' . TBK_API_KEY_ID,
                'Tbk-Api-Key-Secret: ' . TBK_API_KEY_SECRET,
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            $responseBody = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curlError = curl_error($ch);
            curl_close($ch);

            if ($curlError) jsonResponse('error', 'Error Conexión', $curlError);

            $data = json_decode($responseBody, true);

            if ($httpCode === 200 && isset($data['token']) && isset($data['url'])) {
                jsonResponse('success', 'Iniciando Webpay', 'Redirigiendo...', [
                    'token' => $data['token'],
                    'url' => $data['url']
                ]);
            } else {
                jsonResponse('error', 'Error Transbank', 'No se pudo crear la transacción.', ['debug' => $data]);
            }
            break;

        default:
            jsonResponse('error', 'Error', 'Acción no válida.');
    }
} catch (Exception $e) {
    jsonResponse('error', 'Excepción', $e->getMessage());
}
?>