<?php
session_start();

// --- INICIALIZACIÓN DE DATOS LOCALES (MOCK) ---
// Si no existe la lista de eventos en sesión, creamos unos datos de prueba iniciales.
if (!isset($_SESSION['eventos'])) {
    $_SESSION['eventos'] = [
        [
            'id' => 1,
            'titulo' => 'Cena de Aniversario',
            'descripcion' => 'Celebración anual de la empresa con todos los socios.',
            'fecha' => '2023-12-15',
            'hora' => '20:00',
            'precio' => 0.00,
            'categoria' => 'Social',
            'imagen' => '', // Sin imagen inicial
            'estado' => 'activo'
        ],
        [
            'id' => 2,
            'titulo' => 'Seminario de Liderazgo',
            'descripcion' => 'Capacitación intensiva para gerentes de área.',
            'fecha' => '2023-11-20',
            'hora' => '09:00',
            'precio' => 150.00,
            'categoria' => 'Capacitación',
            'imagen' => '', 
            'estado' => 'inactivo'
        ]
    ];
}

// Usamos la sesión como fuente de datos
$eventos_mock = $_SESSION['eventos'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Eventos Corporativos</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #f4f6f9; }
        .card { border: none; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 10px; }
        .sidebar { min-height: 100vh; background: #2c3e50; color: white; }
        .nav-link { color: rgba(255,255,255,0.8); margin-bottom: 5px; }
        .nav-link:hover, .nav-link.active { color: white; background: rgba(255,255,255,0.1); border-radius: 5px; }
        .status-active { color: #198754; font-weight: bold; }
        .status-inactive { color: #6c757d; font-weight: bold; }
        .img-preview { width: 50px; height: 50px; object-fit: cover; border-radius: 5px; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-2 sidebar p-3 d-none d-md-block">
            <h4 class="mb-4 text-center"><i class="fas fa-calendar-alt me-2"></i>Eventos Corp</h4>
            <nav class="nav flex-column">
                <a class="nav-link active" href="#"><i class="fas fa-tachometer-alt me-2"></i> Dashboard</a>
                <a class="nav-link" href="#"><i class="fas fa-globe me-2"></i> Ver Sitio Web</a>
                <a class="nav-link" href="#"><i class="fas fa-cog me-2"></i> Configuración</a>
                <a class="nav-link text-danger mt-5" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i> Cerrar Sesión</a>
            </nav>
        </div>

        <!-- Contenido Principal -->
        <div class="col-md-10 p-4">
            
            <!-- Mensajes de Alerta -->
            <?php if(isset($_GET['status'])): ?>
                <?php if($_GET['status'] == 'success'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> Operación realizada con éxito.
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif($_GET['status'] == 'error'): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> Hubo un error al procesar la solicitud.
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <div class="row">
                <div class="col-12 mb-4">
                    <h2 class="fw-bold text-dark">Gestión de Eventos Mensuales</h2>
                    <p class="text-muted">Administra los eventos que se mostrarán en la página principal.</p>
                </div>

                <!-- Formulario de Creación/Edición -->
                <div class="col-lg-4 mb-4">
                    <div class="card h-100">
                        <div class="card-header bg-primary text-white fw-bold">
                            <i class="fas fa-pen me-2"></i> <span id="formTitle">Nuevo Evento</span>
                        </div>
                        <div class="card-body">
                            <form action="panel_process.php" method="POST" enctype="multipart/form-data" id="eventForm">
                                <input type="hidden" name="action" id="action" value="create">
                                <input type="hidden" name="event_id" id="event_id">

                                <div class="mb-3">
                                    <label class="form-label">Título del Evento</label>
                                    <input type="text" class="form-control" name="titulo" id="titulo" required placeholder="Ej: Cena de Navidad">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Categoría</label>
                                    <select class="form-select" name="categoria" id="categoria" required>
                                        <option value="">Seleccionar...</option>
                                        <option value="Social">Social / Recreativo</option>
                                        <option value="Capacitación">Capacitación / Taller</option>
                                        <option value="Corporativo">Reunión Corporativa</option>
                                        <option value="Lanzamiento">Lanzamiento de Producto</option>
                                    </select>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-6">
                                        <label class="form-label">Fecha</label>
                                        <input type="date" class="form-control" name="fecha" id="fecha" required>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label">Hora</label>
                                        <input type="time" class="form-control" name="hora" id="hora" required>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Precio (USD/CLP)</label>
                                    <div class="input-group">
                                        <span class="input-group-text">$</span>
                                        <input type="number" step="0.01" class="form-control" name="precio" id="precio" value="0.00">
                                    </div>
                                    <div class="form-text">Dejar en 0 para eventos gratuitos.</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Descripción</label>
                                    <textarea class="form-control" name="descripcion" id="descripcion" rows="3" required></textarea>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Imagen Destacada</label>
                                    <input type="file" class="form-control" name="imagen" accept="image/*">
                                </div>

                                <div class="mb-3 form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="estado" id="estado" value="activo" checked>
                                    <label class="form-check-label" for="estado">Mostrar en Web Principal</label>
                                </div>

                                <div class="d-grid gap-2">
                                    <button type="submit" class="btn btn-primary" id="btnSubmit">Guardar Evento</button>
                                    <button type="button" class="btn btn-secondary d-none" id="btnCancel" onclick="resetForm()">Cancelar Edición</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Listado de Eventos -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h5 class="m-0 fw-bold text-secondary">Listado de Eventos</h5>
                            <input type="text" class="form-control w-auto form-control-sm" placeholder="Buscar evento...">
                        </div>
                        <div class="card-body p-0 table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="ps-4">Img</th>
                                        <th>Evento</th>
                                        <th>Fecha</th>
                                        <th>Precio</th>
                                        <th>Estado</th>
                                        <th class="text-end pe-4">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(empty($eventos_mock)): ?>
                                        <tr><td colspan="6" class="text-center py-4">No hay eventos registrados.</td></tr>
                                    <?php else: ?>
                                        <?php foreach($eventos_mock as $evento): ?>
                                        <tr>
                                            <td class="ps-4">
                                                <?php if(!empty($evento['imagen'])): ?>
                                                    <img src="<?php echo $evento['imagen']; ?>" class="img-preview" alt="img">
                                                <?php else: ?>
                                                    <div class="bg-secondary text-white d-flex align-items-center justify-content-center rounded" style="width:50px; height:50px;">
                                                        <i class="fas fa-image"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="fw-bold"><?php echo htmlspecialchars($evento['titulo']); ?></div>
                                                <div class="small text-muted"><?php echo htmlspecialchars($evento['categoria']); ?></div>
                                            </td>
                                            <td>
                                                <div><?php echo date('d/m/Y', strtotime($evento['fecha'])); ?></div>
                                                <div class="small text-muted"><?php echo $evento['hora']; ?></div>
                                            </td>
                                            <td><?php echo $evento['precio'] == 0 ? '<span class="badge bg-success">Gratis</span>' : '$' . number_format($evento['precio'], 2); ?></td>
                                            <td>
                                                <?php if($evento['estado'] == 'activo'): ?>
                                                    <span class="badge bg-soft-success text-success border border-success">Visible</span>
                                                <?php else: ?>
                                                    <span class="badge bg-soft-secondary text-secondary border">Oculto</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end pe-4">
                                                <button class="btn btn-sm btn-outline-primary me-1" 
                                                    onclick='editarEvento(<?php echo json_encode($evento); ?>)'>
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                
                                                <form action="panel_process.php" method="POST" class="d-inline" onsubmit="return confirm('¿Estás seguro de eliminar este evento?');">
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="event_id" value="<?php echo $evento['id']; ?>">
                                                    <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash-alt"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function editarEvento(evento) {
        document.getElementById('formTitle').innerText = 'Editar Evento';
        document.getElementById('btnSubmit').innerText = 'Actualizar Evento';
        document.getElementById('btnCancel').classList.remove('d-none');
        
        document.getElementById('action').value = 'update';
        document.getElementById('event_id').value = evento.id;
        document.getElementById('titulo').value = evento.titulo;
        document.getElementById('descripcion').value = evento.descripcion;
        document.getElementById('fecha').value = evento.fecha;
        document.getElementById('hora').value = evento.hora;
        document.getElementById('precio').value = evento.precio;
        document.getElementById('categoria').value = evento.categoria;
        
        document.getElementById('estado').checked = (evento.estado === 'activo');
        
        document.querySelector('.card').scrollIntoView({ behavior: 'smooth' });
    }

    function resetForm() {
        document.getElementById('eventForm').reset();
        document.getElementById('formTitle').innerText = 'Nuevo Evento';
        document.getElementById('btnSubmit').innerText = 'Guardar Evento';
        document.getElementById('action').value = 'create';
        document.getElementById('event_id').value = '';
        document.getElementById('btnCancel').classList.add('d-none');
    }
</script>

</body>
</html>